 <?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Client;

class ClientController extends Controller
{
    public function index() {
        return response()->json(Client::all());
    }

    public function store(Request $request) {
        $client = Client::create($request->all());
        return response()->json($client, 201);
    }

    public function show($id) {
        return response()->json(Client::findOrFail($id));
    }

    public function update(Request $request, $id) {
        $client = Client::findOrFail($id);
        $client->update($request->all());
        return response()->json($client);
    }

    public function destroy($id) {
        Client::findOrFail($id)->delete();
        return response()->json(['message' => 'Client deleted']);
    }
}
