<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Payment;
use Illuminate\Support\Facades\Log;

class WebhookController extends Controller
{
    public function handle(Request $request)
    {
        Log::info('LemonSqueezy Webhook', $request->all());

        $event = $request->input('meta.event_name');

        if ($event === 'order_payment') {
            Payment::create([
                'external_id' => $request->input('data.id'),
                'processor'   => 'lemonsqueezy',
                'amount'      => $request->input('data.attributes.total'),
                'currency'    => $request->input('data.attributes.currency'),
                'status'      => 'succeeded',
                'raw_webhook' => json_encode($request->all()),
            ]);
        }

        return response()->json(['success' => true]);
    }
}
