<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;

    protected $table = 'bbm_payments';

    protected $fillable = [
        'invoice_id',
        'external_id',
        'processor',
        'amount',
        'currency',
        'status',
        'paid_at',
        'raw_webhook'
    ];

    protected $casts = [
        'raw_webhook' => 'array',
        'paid_at' => 'datetime',
    ];

    // Relationships
    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id');
    }
}
